% ------------------------------------------------------------ %
% Vraca vrstu vektor nula Cebisevljevog polinoma n-tog stepena %
% na intervalu [-a, a]                                         %
% ------------------------------------------------------------ %

function y = CebisevljeveNule( a, n )

if nargin ~= 2
    error( 'Nedovoljan broj argumenata' )
elseif a <= 0
    error( 'Argument a mora biti pozitivan' )
elseif n <= 0 | abs( n - round( n ) ) > eps
    error( 'n mora biti prirodan broj' )
end

x = 1 : 2 : 2*n-1;
y = a * cos( x * pi / (2*n) );